USE Goran
SET STATISTICS TIME ON
SET STATISTICS IO ON

-- Agregovan statistiky timesheet po pracovncch
SELECT
	PracovnikID,
	-- Poet schvlench zznam (sloupec SchvalenoKdy je NULL)
	(SELECT COUNT(*) FROM TimesheetItem ti
		WHERE (SchvalenoKdy IS NOT NULL)
			AND (ti.PracovnikID = Pracovnik.PracovnikID)
			AND (ti.Deleted IS NULL)
	) AS PocetSchvalenychZaznamu,
	-- Poet neschvlench zznam (sloupec SchvalenoKdy nen NULL)
	(SELECT COUNT(*) FROM TimesheetItem ti
		WHERE (SchvalenoKdy IS NULL)
			AND (ti.PracovnikID = Pracovnik.PracovnikID)
			AND (ti.Deleted IS NULL)
	) AS PocetNeschvalenychZaznamu,
	-- Poet schvlench hodin (sloupec SchvalenoKdy je NULL)
	(SELECT SUM(PocetHodin) FROM TimesheetItem ti
		WHERE (SchvalenoKdy IS NOT NULL)
			AND (ti.PracovnikID = Pracovnik.PracovnikID)
			AND (ti.Deleted IS NULL)
	) AS PocetSchvalenychHodin,
	-- Poet neschvlench hodin (sloupec SchvalenoKdy nen NULL)
	(SELECT SUM(PocetHodin) FROM TimesheetItem ti
		WHERE (SchvalenoKdy IS NULL)
			AND (ti.PracovnikID = Pracovnik.PracovnikID)
			AND (ti.Deleted IS NULL)
	) AS PocetNeschvalenychHodin,
	-- Poet hodin celkem (bez podmnky)
	(SELECT SUM(OsobniNaklady) FROM TimesheetItem ti
		WHERE (ti.PracovnikID = Pracovnik.PracovnikID)
			AND (ti.Deleted IS NULL)
	) AS OsobniNakladyCelkem,
	-- Ze kdy je posledn schvlen hodina
	(SELECT MAX(Created) FROM TimesheetItem ti
		WHERE (SchvalenoKdy IS NOT NULL)
			AND (ti.PracovnikID = Pracovnik.PracovnikID)
			AND (ti.Deleted IS NULL)
	) AS PosledniSchvalenaHodinaCreated,
	-- Poet hodin bez kategorie
	(SELECT SUM(PocetHodin) FROM TimesheetItem ti
		WHERE (ti.TimesheetItemCategoryID IS NULL)
			AND (ti.PracovnikID = Pracovnik.PracovnikID)
			AND (ti.Deleted IS NULL)
	) AS PocetHodinBezKategorie
	FROM Pracovnik
	WHERE
		-- Spolen filtran podmnky vech zznam
		(PracovnikID > 0)
		AND (Pracovnik.Deleted IS NULL)
		AND (Pracovnik.Aktivni = 1)
		AND ((Pracovnik.DatumOdchodu IS NULL) OR (Pracovnik.DatumOdchodu > GETDATE()))
	ORDER BY PracovnikID
	
	
-- Jin zpis - jeden prchod
SELECT
	Pracovnik.PracovnikID,
	SUM(CASE WHEN SchvalenoKdy IS NOT NULL THEN 1 ELSE 0 END)
		AS PocetSchvalenychZaznamu,
	SUM(CASE WHEN SchvalenoKdy IS NULL THEN 1 ELSE 0 END)
		AS PocetNeschvalenychZaznamu,
	SUM(CASE WHEN SchvalenoKdy IS NOT NULL THEN PocetHodin ELSE 0 END)
		AS PocetSchvalenychHodin,
	SUM(CASE WHEN SchvalenoKdy IS NULL THEN PocetHodin ELSE 0 END)
		AS PocetNeschvalenychHodin,
	SUM(OsobniNaklady) AS OsobniNakladyCelkem,
	MAX(CASE WHEN SchvalenoKdy IS NOT NULL THEN TimesheetItem.Created ELSE NULL END) AS PosledniSchvalenaHodina,
	SUM(CASE WHEN TimesheetItem.TimesheetItemCategoryID IS NULL THEN PocetHodin ELSE 0 END) AS PocetHodinBezKategorie
	FROM Pracovnik
		LEFT JOIN TimesheetItem ON (TimesheetItem.PracovnikID = Pracovnik.PracovnikID)
	WHERE
		-- Spolen filtran podmnky vech zznam
		(Pracovnik.PracovnikID > 0)
		AND (TimesheetItem.Deleted IS NULL)
		AND (Pracovnik.Deleted IS NULL)
		AND (Pracovnik.Aktivni = 1)
		AND ((Pracovnik.DatumOdchodu IS NULL) OR (Pracovnik.DatumOdchodu > GETDATE()))
	GROUP BY Pracovnik.PracovnikID
	ORDER BY Pracovnik.PracovnikID

-- Vkon oproti poddotazm nutno testovat !!!
-- Efektivn zejmna u slab indexovanch nebo neindexovanch tabulek (heap).